@file:Suppress("SpellCheckingInspection")

plugins {
    id("com.strategyobject.sokit.plugins.entry")
    id("com.strategyobject.sokit.plugins.application")
}

group = "com.dev.registration"

description = "StrategyObject - Company Registration System"

version = file(rootDir.toPath().resolve("gradle").resolve("version.txt")).readText().trim()

allprojects {
    group = rootProject.group
    version = rootProject.version
}

dependencies {
    sokit {
        initialize()
        layerJasper()
        layerOidc()
        layerDocumentPanache()
        useDbPostgres(true)
    }
    sokitPlatform {
        // more platform dependencies
    }
    api(project(":document"))
}
