package com.dev.registration.company.data;

import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import lombok.*;

import com.strategyobject.sokit.extensions.dm.api.annotations.Dto;

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Embeddable
@Dto(variant = "Entry")
public class CompanyAddress implements Serializable {
  @NotEmpty
  @Size(max = 100)
  @Column(name = "street", length = 100)
  private String street;

  @NotEmpty
  @Size(max = 50)
  @Column(name = "CITY", length = 50)
  private String city;

  @NotEmpty
  @Size(max = 20)
  @Column(name = "STATE", length = 20)
  private String state;

  @NotEmpty
  @Size(max = 10)
  @Column(name = "ZIP", length = 10)
  private String zip;
}
