package com.dev.registration.company.data;

import jakarta.persistence.*;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Set;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import com.strategyobject.sokit.extensions.dm.api.annotations.Dto;
import com.strategyobject.sokit.extensions.document.api.entities.DocumentEntity;

@Entity
@Table(name = "TBL_COMPANY")
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Dto(variant = "View", altVariants = "Entry")
@Dto(variant = "Searchable", altVariants = "Entry")
@Dto(variant = "Submit", altVariants = "Entry")
@Dto(variant = "Approve", altVariants = "Entry", includeAll = false)
@Dto(variant = "Reject", altVariants = "Entry", includeAll = false)
public class CompanyEntity extends DocumentEntity implements Serializable {

  @NotEmpty
  @Size(max = 100)
  @Column(name = "COMPANY_NAME", length = 100)
  private String companyName;

  @NotEmpty
  @Size(max = 5)
  @Column(name = "LEGAL_FORM", length = 5)
  private String legalForm; // enum?

  @NotNull
  @Column(name = "ESTABLISHED_DATE")
  private LocalDate establishedDate;

  @NotNull
  @Positive
  @Column(name = "CAPITAL")
  private BigDecimal capital;

  @NotNull
  @Positive
  @Column(name = "EMPLOYEES")
  @Min(1)
  private Integer employees = 0;

  @Embedded @Valid @NotNull private CompanyType type;

  private String creatorSubject;

  @NotEmpty
  @Size(max = 50)
  @Column(name = "PHONE", length = 50)
  private String phone;

  @NotEmpty
  @Size(max = 50)
  @Email(message = "email not vaild")
  @Column(name = "EMAIL", length = 50)
  private String email;

  @Size(max = 11)
  @Column(name = "VAT_NUMBER", length = 11)
  @Dto.Include({"Approve", "Reject"})
  private String vatNumber;

  @Size(max = 4000)
  @Column(name = "remark", length = 4000)
  @Dto.Include({"Approve", "Reject"})
  private String remark;

  @Embedded @Valid @NotNull private CompanyAddress address;

  @NotEmpty
  @Column(name = "website", length = 150)
  private String website;

  @Valid
  @NotNull
  @Dto.Exclude({"Searchable"})
  @OneToMany(fetch = FetchType.LAZY, cascade = CascadeType.ALL, mappedBy = "parent")
  @Size(min = 1)
  private Set<@Valid @NotNull ShareholderEntity> shareholders;

  @Override
  public int hashCode() {
    return super.hashCode();
  }

  @Override
  public boolean equals(Object o) {
    return super.equals(o);
  }
}
