package com.dev.registration.company.data;

import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import lombok.*;

import com.strategyobject.sokit.extensions.dm.api.annotations.Dto;

@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Embeddable
@Dto(variant = "Entry")
public class CompanyType implements Serializable {
  @NotEmpty
  @Size(max = 10)
  @Column(name = "CODE", length = 10)
  private String code;

  @NotEmpty
  @Size(max = 255)
  @Column(name = "DESCRIPTION", length = 255)
  private String description;
}
