package com.dev.registration.company.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.*;
import jakarta.validation.constraints.*;
import java.io.Serializable;
import java.util.Objects;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import com.strategyobject.sokit.extensions.core.exceptions.dto.SubElement;
import com.strategyobject.sokit.extensions.dm.api.annotations.Dto;

@SuppressWarnings({"MoreThanOneIdInspection", "unused"})
@Entity
@Table(name = "TBL_SHAREHOLDER")
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@Dto(variant = "Entry")
public class ShareholderEntity extends SubElement implements Serializable {

  @NotEmpty
  @Size(max = 255)
  @Id
  @Column(name = "SHAREHOLDER_ID", nullable = false, updatable = false)
  private String id;

  @Id
  @JsonIgnore
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "DOCUMENT_ID", referencedColumnName = "DOCUMENT_ID")
  private CompanyEntity parent;

  @NotEmpty
  @Size(max = 50)
  @Column(name = "FIRST_NAME", length = 50)
  private String firstName;

  @NotEmpty
  @Size(max = 50)
  @Column(name = "LAST_NAME", length = 50)
  private String lastName;

  @NotEmpty
  @Size(max = 50)
  @Column(name = "PHONE", length = 50)
  private String phone;

  @NotEmpty
  @Size(max = 50)
  @Email(message = "email not vaild")
  @Column(name = "EMAIL", length = 50)
  private String email;

  @NotNull
  @Positive
  @Column(name = "shares")
  private Integer shares = 0;

  @NotNull
  @Min(1)
  @Max(100)
  @Column(name = "percentage")
  private Double percentage;

  @Override
  public boolean equals(Object o) {
    if (o == null || getClass() != o.getClass()) return false;
    ShareholderEntity that = (ShareholderEntity) o;
    return Objects.equals(id, that.id);
  }

  @Override
  public int hashCode() {
    return Objects.hashCode(id);
  }
}
