package com.dev.registration.company.document;

import com.dev.registration.company.data.CompanyEntity;
import com.dev.registration.company.data.dm.CompanySearchableDto;
import com.dev.registration.company.document.filters.DefaultFilter;
import com.dev.registration.company.document.security.SecuritySearch;

import com.strategyobject.sokit.extensions.core.annotations.FeatureFlag;
import com.strategyobject.sokit.extensions.core.annotations.SecurityRequirement;
import com.strategyobject.sokit.extensions.document.api.annotations.Document;
import com.strategyobject.sokit.extensions.document.providers.panache.PanacheProvider;
import com.strategyobject.sokit.extensions.qdsl.annotations.Search;

@SecurityRequirement(
    mustAuthenticate = true,
    mustAuthorize = true,
    rolePattern = "so:companies:{name}")
@Document(
    name = "Company",
    description = "Company Document",
    module = "registration",
    document = "company",
    version = 1,
    stateType = States.class,
    startOperationType = StartOperations.class,
    operationType = Operations.class,
    entityType = CompanyEntity.class,
    search =
        @Search(
            description = DefaultFilter.DESCRIPTION,
            projectionType = CompanySearchableDto.class,
            security = SecuritySearch.class,
            filter = DefaultFilter.class),
    featureFlags = @FeatureFlag(key = "transactional"),
    provider = PanacheProvider.class)
public interface CompanyDocument {}
