package com.dev.registration.company.document;

import com.dev.registration.company.data.dm.CompanyApproveDto;
import com.dev.registration.company.data.dm.CompanyRejectDto;
import com.dev.registration.company.data.dm.CompanySubmitDto;
import com.dev.registration.company.document.security.SecurityReview;
import com.dev.registration.company.document.security.SecuritySubmission;

import com.strategyobject.sokit.extensions.document.api.annotations.DocumentOperations;
import com.strategyobject.sokit.extensions.document.api.annotations.Operation;

@DocumentOperations
public enum Operations {
  @Operation(
      ordinal = 1,
      summary = "Create Company",
      description = "Create Company",
      startState = "NIL",
      endState = "SUBMITTED",
      startOperation = "NEW",
      security = SecuritySubmission.class,
      inputType = CompanySubmitDto.class)
  SUBMIT,

  @Operation(
      ordinal = 1,
      summary = "Approve Company",
      description = "Approve Company",
      startState = "SUBMITTED",
      endState = "APPROVED",
      startOperation = "REVIEW",
      security = SecurityReview.class,
      inputType = CompanyApproveDto.class)
  APPROVE,

  @Operation(
      ordinal = 2,
      summary = "Reject Company",
      description = "Reject Company",
      startState = "SUBMITTED",
      endState = "REJECTED",
      security = SecurityReview.class,
      startOperation = "REVIEW",
      inputType = CompanyRejectDto.class)
  REJECT,
}
