package com.dev.registration.company.document;

import com.dev.registration.company.data.dm.CompanyViewDto;
import com.dev.registration.company.document.security.SecurityAll;

import com.strategyobject.sokit.extensions.document.api.annotations.DocumentStartOperations;
import com.strategyobject.sokit.extensions.document.api.annotations.StartOperation;
import com.strategyobject.sokit.extensions.document.api.types.StartOperationType;

@DocumentStartOperations
public enum StartOperations {
  @StartOperation(
      ordinal = 1,
      type = StartOperationType.READ,
      summary = "View Company",
      description = "View Company",
      security = SecurityAll.class,
      outputType = CompanyViewDto.class)
  VIEW,

  @StartOperation(
      ordinal = 1,
      type = StartOperationType.CREATE,
      summary = "New Company",
      description = "New Company",
      outputType = CompanyViewDto.class)
  NEW,

  @StartOperation(
      ordinal = 2,
      type = StartOperationType.UPDATE,
      summary = "Review Company",
      description = "Review Company",
      outputType = CompanyViewDto.class)
  REVIEW,
}
