package com.dev.registration.company.document.filters;

import static com.strategyobject.sokit.extensions.qdsl.QueryAst.QueryExpression.QueryField.ofDate;
import static com.strategyobject.sokit.extensions.qdsl.QueryAst.QueryExpression.QueryField.ofString;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.microprofile.openapi.annotations.media.Schema;

import com.strategyobject.sokit.extensions.core.context.SOContext;
import com.strategyobject.sokit.extensions.qdsl.QueryAst;
import com.strategyobject.sokit.extensions.qdsl.dm.SearchFilter;

@Schema(
    name = "DefaultFilter",
    title = "Default Filter",
    description = DefaultFilter.DESCRIPTION,
    implementation = String.class)
public class DefaultFilter extends SearchFilter {

  public static final String DESCRIPTION =
      """
          Default Search Filter:

          __Available filters__

          - *metadata.current.state* The current state of the registration document of the company.
          - *data.establishedDate* The esblished date of the company.
          """;

  public DefaultFilter(String filter) {
    super(filter);
  }

  @Override
  public Set<QueryAst.QueryExpression.QueryField<?>> fields(String id, SOContext ctx) {
    final var set = new HashSet<QueryAst.QueryExpression.QueryField<?>>();
    set.add(ofString("metadata.current.state"));
    set.add(ofDate("data.establishedDate"));
    return set;
  }
}
