@file:Suppress("SpellCheckingInspection", "UnstableApiUsage")

rootProject.name = "company-registration-system"

buildscript {
    fun getConfigString(key: String): String {
        if (System.getProperties().containsKey(key)) {
            val tmpValue: String = System.getProperty(key)
            if (tmpValue.trim { it <= ' ' }.isNotEmpty()) {
                return tmpValue.trim { it <= ' ' }
            }
        }
        val envKey = key.uppercase().replace('.', '_')
        if (System.getenv().containsKey(envKey)) {
            val tmpValue: String = System.getenv(envKey)
            if (tmpValue.trim { it <= ' ' }.isNotEmpty()) {
                return tmpValue.trim { it <= ' ' }
            }
        }
        if (providers.gradleProperty(key).isPresent) {
            val tmpValue = providers.gradleProperty(key).getOrElse("")
            if (tmpValue.trim { it <= ' ' }.isNotEmpty()) {
                return tmpValue.trim { it <= ' ' }
            }
        }
        return ""
    }

    val repositoryLocal = getConfigString("so.repository.local")
    val repository = getConfigString("so.repository")
    val repositoryCredName = getConfigString("so.repository.cred.name")
    val repositoryCredValue = getConfigString("so.repository.cred.value")

    repositories {
        gradlePluginPortal {
            name = "Gradle"
        }
        mavenCentral {
            name = "MavenCentral"
        }
        google {
            name = "Google"
        }
        if (repositoryLocal.isNotBlank()) {
            maven {
                name = "SOLocal"
                url =
                    uri(
                        repositoryLocal,
                    )
            }
        }
        if (repository.isNotBlank()) {
            maven {
                name = "SOGitlab"
                url =
                    uri(
                        repository,
                    )
                if (repositoryCredName.isNotBlank() && repositoryCredValue.isNotBlank()) {
                    credentials(HttpHeaderCredentials::class) {
                        name = repositoryCredName
                        value = repositoryCredValue
                    }
                    authentication {
                        create<HttpHeaderAuthentication>("header")
                    }
                }
            }
        }
    }

    dependencies {
        val sokitVersion = file(rootDir.resolve("gradle").resolve("sokit.txt")).readText().trim()
        classpath("com.strategyobject.sokit:sokit-plugins:$sokitVersion")
    }
}

apply(plugin = "com.strategyobject.sokit.plugins.sokit")

include(":data")
include(":document")
