package com.dev.registration.company.flow;

import com.dev.registration.company.data.CompanyEntity;
import com.dev.registration.company.document.CompanyDocument;
import com.dev.registration.company.document.Operations;
import com.dev.registration.company.document.StartOperations;
import com.dev.registration.company.document.States;
import com.dev.registration.company.document.document.events.CompanyOperationEventsResolver;
import com.dev.registration.company.flow.events.ValidateRemark;
import com.dev.registration.company.flow.events.ValidateShare;
import com.dev.registration.company.flow.events.ValidateVatNumber;

import com.strategyobject.sokit.extensions.document.DocumentResolverTransaction;
import com.strategyobject.sokit.extensions.document.DocumentTransaction;
import com.strategyobject.sokit.extensions.document.api.annotations.DocumentAware;

@DocumentAware(CompanyDocument.class)
public class EventsResolver implements CompanyOperationEventsResolver {

  @Override
  public void resolve(
      DocumentResolverTransaction<States, StartOperations, Operations, String, CompanyEntity>
          transaction) {
    final var op = transaction.operation();
    if (op == Operations.SUBMIT) {
      transaction.addPreEvent(ValidateShare.class);
    }
    if (op == Operations.REJECT) {
      transaction.addPreEvent(ValidateRemark.class);
    }

    if (op == Operations.APPROVE) {
      transaction.addPreEvent(ValidateVatNumber.class);
    }
  }

  // Called only if there are more than one state
  @Override
  public States resolveEndState(
      DocumentTransaction<States, StartOperations, Operations, String, CompanyEntity> transaction) {
    return null;
  }
}
