package com.dev.registration.company.flow.events;

import static com.strategyobject.sokit.extensions.core.utils.ObjectUtils.isEmpty;
import static com.strategyobject.sokit.extensions.core.utils.ObjectUtils.isNotEmpty;
import static com.strategyobject.sokit.extensions.core.utils.StringUtils.trim;

import com.dev.registration.company.data.CompanyEntity;
import com.dev.registration.company.document.CompanyDocument;
import com.dev.registration.company.document.Operations;
import com.dev.registration.company.document.StartOperations;
import com.dev.registration.company.document.States;
import com.dev.registration.company.document.document.events.CompanyOperationEvent;
import com.dev.registration.company.flow.exceptions.EmptyRemarkException;
import com.dev.registration.company.flow.exceptions.NotEmptyVatNumberException;
import lombok.RequiredArgsConstructor;

import com.strategyobject.sokit.extensions.document.DocumentTransaction;
import com.strategyobject.sokit.extensions.document.api.annotations.DocumentAware;

@DocumentAware(CompanyDocument.class)
@RequiredArgsConstructor
public class ValidateRemark implements CompanyOperationEvent {

  @Override
  public void execute(
      DocumentTransaction<States, StartOperations, Operations, String, CompanyEntity> transaction) {
    final var entity = transaction.entity();
    if (entity == null) {
      return;
    }
    final var remark = trim(entity.getRemark());
    final var vatNumber = trim(entity.getVatNumber());

    entity.setRemark(remark);
    if (!isNotEmpty(remark)) {
      throw EmptyRemarkException.builder().build().path("remark");
    }

    if (!isEmpty(vatNumber)) {
      throw NotEmptyVatNumberException.builder().build().path("vatNumber");
    }
  }
}
