package com.dev.registration.company.flow.requests;

import com.dev.registration.company.data.CompanyEntity;
import com.dev.registration.company.data.dm.CompanyApproveDto;
import com.dev.registration.company.document.CompanyDocument;
import com.dev.registration.company.document.Operations;
import com.dev.registration.company.document.StartOperations;
import com.dev.registration.company.document.States;
import com.dev.registration.company.document.document.events.CompanyApproveDtoRequestEvent;
import com.dev.registration.company.mappers.CompanyMapper;

import com.strategyobject.sokit.extensions.document.DocumentTransaction;
import com.strategyobject.sokit.extensions.document.api.annotations.DocumentAware;

@DocumentAware(CompanyDocument.class)
public class ApproveRequestEvent implements CompanyApproveDtoRequestEvent {

  private final CompanyMapper mapper;

  public ApproveRequestEvent(CompanyMapper mapper) {
    this.mapper = mapper;
  }

  @Override
  public void execute(
      DocumentTransaction<States, StartOperations, Operations, String, CompanyEntity> transaction,
      CompanyApproveDto input) {
    // map dto to entity
    mapper.map(transaction.ctx(), input, transaction.entity());
  }
}
