package com.dev.registration.company.flow.requests;

import com.dev.registration.company.data.CompanyEntity;
import com.dev.registration.company.data.dm.CompanyRejectDto;
import com.dev.registration.company.document.CompanyDocument;
import com.dev.registration.company.document.Operations;
import com.dev.registration.company.document.StartOperations;
import com.dev.registration.company.document.States;
import com.dev.registration.company.document.document.events.CompanyRejectDtoRequestEvent;
import com.dev.registration.company.mappers.CompanyMapper;

import com.strategyobject.sokit.extensions.document.DocumentTransaction;
import com.strategyobject.sokit.extensions.document.api.annotations.DocumentAware;

@DocumentAware(CompanyDocument.class)
public class RejectRequestEvent implements CompanyRejectDtoRequestEvent {

  private final CompanyMapper mapper;

  public RejectRequestEvent(CompanyMapper mapper) {
    this.mapper = mapper;
  }

  @Override
  public void execute(
      DocumentTransaction<States, StartOperations, Operations, String, CompanyEntity> transaction,
      CompanyRejectDto input) {
    mapper.map(transaction.ctx(), input, transaction.entity());
  }
}
