package com.dev.registration.company.flow.requests;

import com.dev.registration.company.data.CompanyEntity;
import com.dev.registration.company.data.dm.CompanySubmitDto;
import com.dev.registration.company.document.CompanyDocument;
import com.dev.registration.company.document.Operations;
import com.dev.registration.company.document.StartOperations;
import com.dev.registration.company.document.States;
import com.dev.registration.company.document.document.events.CompanySubmitDtoRequestEvent;
import com.dev.registration.company.mappers.CompanyMapper;

import com.strategyobject.sokit.extensions.document.DocumentTransaction;
import com.strategyobject.sokit.extensions.document.api.annotations.DocumentAware;

@DocumentAware(CompanyDocument.class)
public class SubmitRequestEvent implements CompanySubmitDtoRequestEvent {

  private final CompanyMapper mapper;

  public SubmitRequestEvent(CompanyMapper mapper) {
    this.mapper = mapper;
  }

  @Override
  public void execute(
      DocumentTransaction<States, StartOperations, Operations, String, CompanyEntity> transaction,
      CompanySubmitDto input) {
    final var ctx = transaction.ctx();

    String subject = ctx.identity().getSubject();
    input.setCreatorSubject(subject);
    mapper.map(transaction.ctx(), input, transaction.entity());
  }
}
