package com.dev.registration.company.flow.responses;

import com.dev.registration.company.data.CompanyEntity;
import com.dev.registration.company.data.dm.CompanyViewDto;
import com.dev.registration.company.document.CompanyDocument;
import com.dev.registration.company.document.Operations;
import com.dev.registration.company.document.StartOperations;
import com.dev.registration.company.document.States;
import com.dev.registration.company.document.document.events.CompanyViewDtoResponseEvent;
import com.dev.registration.company.mappers.CompanyMapper;

import com.strategyobject.sokit.extensions.document.DocumentTransaction;
import com.strategyobject.sokit.extensions.document.api.annotations.DocumentAware;

@DocumentAware(CompanyDocument.class)
public class ViewResponseEvent implements CompanyViewDtoResponseEvent {

  private final CompanyMapper mapper;

  public ViewResponseEvent(CompanyMapper mapper) {
    this.mapper = mapper;
  }

  @Override
  public CompanyViewDto execute(
      DocumentTransaction<States, StartOperations, Operations, String, CompanyEntity> transaction) {
    CompanyViewDto companyViewDto = mapper.mapView(transaction.entity());
    // companyViewDto.setCreatorSubject(null); // hide the subject
    return companyViewDto;
  }
}
