package com.dev.registration.company.mappers;

import static org.mapstruct.MappingConstants.ComponentModel.JAKARTA_CDI;

import com.dev.registration.company.data.CompanyEntity;
import com.dev.registration.company.data.ShareholderEntity;
import com.dev.registration.company.data.dm.*;
import org.mapstruct.*;
import org.mapstruct.control.DeepClone;

@Mapper(
    componentModel = JAKARTA_CDI,
    builder = @Builder(disableBuilder = true),
    mappingControl = DeepClone.class)
public interface CompanyEntityMapper {

  CompanyViewDto mapView(CompanyEntity entity);

  CompanySearchableDto mapSearchable(CompanyEntity entity);

  @Mapping(target = "shareholders", ignore = true)
  void map(CompanySubmitDto entry, @MappingTarget CompanyEntity entity);

  @Mapping(target = "shareholders", ignore = true)
  void map(CompanyApproveDto entry, @MappingTarget CompanyEntity entity);

  @Mapping(target = "shareholders", ignore = true)
  void map(CompanyRejectDto entry, @MappingTarget CompanyEntity entity);

  @Mapping(target = "id", ignore = true)
  @Mapping(target = "parent", ignore = true)
  void map(ShareholderEntryDto entry, @MappingTarget ShareholderEntity entity);
}
