package com.dev.registration.company.mappers;

import com.dev.registration.company.data.CompanyEntity;
import com.dev.registration.company.data.ShareholderEntity;
import com.dev.registration.company.data.dm.*;
import jakarta.enterprise.context.ApplicationScoped;

import com.strategyobject.sokit.extensions.core.context.SOContext;

@ApplicationScoped
public class CompanyMapper {

  private final CompanyEntityMapper companyEntityMapper;

  private final ShareholdersMapper itemEntityMapper;

  public CompanyMapper(
      CompanyEntityMapper companyEntityMapper, ShareholdersMapper itemEntityMapper) {
    this.companyEntityMapper = companyEntityMapper;
    this.itemEntityMapper = itemEntityMapper;
  }

  public CompanyViewDto mapView(CompanyEntity entity) {
    return companyEntityMapper.mapView(entity);
  }

  public CompanySearchableDto mapSearchable(CompanyEntity entity) {
    return companyEntityMapper.mapSearchable(entity);
  }

  public void map(SOContext ctx, CompanySubmitDto entry, CompanyEntity entity) {
    companyEntityMapper.map(entry, entity);
    itemEntityMapper.addAll(ctx, entry.getShareholders(), entity);
  }

  public void map(SOContext ctx, CompanyApproveDto entry, CompanyEntity entity) {
    companyEntityMapper.map(entry, entity);
  }

  public void map(SOContext ctx, CompanyRejectDto entry, CompanyEntity entity) {
    companyEntityMapper.map(entry, entity);
  }

  public void map(ShareholderEntryDto entry, ShareholderEntity entity) {
    companyEntityMapper.map(entry, entity);
  }
}
