# Company

## Description
This project is a React-based web application based on SOKitUI React framework.
It uses Vite for building and development, and includes a mock express server for API testing.

This application is just an **empty template** to start a new project. 
It is not a complete application and does not have any specific functionality.

## Getting started

To install and run this project locally, follow these steps:

- Install the dependencies:
    ```bash
    pnpm install
    ```
To run the application there are 2 possibilities:
1. **Development mode**:
   run the application taking the environment variables from `.env.development` file, and should be used
   with an already running backend server.
    ```bash
    pnpm dev
    ```
   
2. **Mock dev**: run the application with a mock server that will simulate the backend API through an express server,
   located in the src-mock folder.
    ```bash
    pnpm mock:dev
    ```
   For this to work, you also need to run the mock server:
    ```bash
    pnpm mock:server
    ```
   Otherwise, the applicazion backend call will fail.

If you want to run the application in production mode, you can:
- Build the application:
    ```bash
    pnpm build
    ```
- Run the application:
    ```bash
    pnpm start
    ```
This will start the application in production mode, taking the environment variables from `.env.production` file.

Once you launch the application, you can access it at [http://localhost:3004](http://localhost:3004).