const express = require('express');

const app = express();

const port = 3000;

app.use((req, res, next) => {
    res.header('Access-Control-Allow-Origin', '*');
    res.header('Access-Control-Allow-Headers', '*');
    next();
});

app.get('/api/v1/registration/company/search', (reg, res ) => {
    res.send(require('./data/search.json'));
});

app.get('/api/v1/registration/company/start-operations/:id/view', (reg, res ) => {
    res.send(require('./data/view.json'));
});

app.get('/api/v1/registration/company/start-operations/:id/review', (reg, res ) => {
    res.send(require('./data/review.json'));
});

app.get('/api/v1/registration/company/start-operations/new', (reg, res ) => {
    res.send(require('./data/new.json'));
});

app.post('/api/v1/registration/company/operations/submit', (reg, res ) => {
    res.send(require('./data/submit.json'));
});

app.put('/api/v1/registration/company/operations/:id/approve', (reg, res ) => {
    res.send(require('./data/approve.json'));
});

app.put('/api/v1/registration/company/operations/:id/reject', (reg, res ) => {
    res.send(require('./data/reject.json'));
});

app.listen(port, (hostname) => {
    console.log(`Example app listening on port ${port}`);
});
