const AppConfig = {
  oidc: {
    issuerUri: import.meta.env.VITE_OIDC_ISSUER,
    clientId: import.meta.env.VITE_OIDC_CLIENT_ID,
    homeUrl: import.meta.env.VITE_OIDC_BASE_URL,
    scopes: 'openid email profile',
    autoLogin: true,
    debugLogs: false,
    mockEnabled: import.meta.env.VITE_MOCK || false,
    mockUser: {
      username: 'alice',
      upn: 'alice',
      name: 'Alice Doe',
      firstName: 'Alice',
      middleNames: '',
      lastName: 'Doe',
      nickName: 'Ally',
      issuer: 'https://sso.strategyobject.com',
      subject: 'alice',
      gender: undefined,
      birthdate: undefined,
      address: {},
      phone: '',
      phoneVerified: false,
      email: 'alice.doe@strategyobject.com',
      emailVerified: true,
      tokenId: '',
      rawToken: '',
      expirationTime: 0,
      expiration: undefined,
      issuedAtTime: 0,
      issuedAt: undefined,
      notBeforeTime: 0,
      notBefore: undefined,
      authTime: 0,
      auth: undefined,
      updatedAtTime: 0,
      updatedAt: undefined,
      audience: [],
      roles: ['company'],
      scopes: [],
      claims: {},
      ownership: [],
      authenticated: true,
      picture:
        'https://images.unsplash.com/photo-1550525811-e5869dd03032?ixlib=rb-1.2.1&auto=format&fit=facearea&facepad=2&w=256&h=256&q=80',
      locale: 'en',
    },
  },
  navbar: {
    darkToggle: true,
    languageMenu: true,
  },
  sidebar: {
    indent: 8,
  },
  i18n: {
    languages: [
      {
        code: 'en',
        emoji: '🇺🇸',
        name: 'English',
      },
      {
        code: 'fr',
        emoji: '🇫🇷',
        name: 'Français',
      },
    ],
  },
  company: {
    apiBase: import.meta.env.VITE_COMPANY_API_BASE,
    apiUri: import.meta.env.VITE_COMPANY_API_URI,
  },
};

const isDev = import.meta.env.DEV;

if (isDev) {
  // change some configuration params
}

export default AppConfig;
