import './styles/index.css';
import { RouterProvider, createHashRouter } from 'react-router';
import { OidcWrapperProvider } from 'so-kit-ui';
import { AppCatchAll } from './app-catch-all.jsx';
import { AppCatchAuth } from './app-catch-auth.jsx';
import config from './app-config.jsx';
import { App } from './app.jsx';
import { CompanyForm } from './pages/company/company-form.jsx';
import { CompanySearch } from './pages/company/company-search.jsx';
import { Home } from './pages/home.jsx';

const routes = createHashRouter([
  {
    Component: App,
    children: [
      {
        index: true,
        Component: Home,
      },
      {
        path: 'companies',
        children: [
          {
            index: true,
            Component: CompanySearch,
          },
          {
            path: ':startOperation',
            Component: CompanyForm,
          },
          {
            path: ':id/:startOperation',
            Component: CompanyForm,
          },
        ],
      },
    ],
  },
  {
    path: '401',
    Component: AppCatchAuth,
  },
  {
    path: '*',
    Component: AppCatchAll,
  },
]);

export const AppRoutes = () => {
  return (
    <OidcWrapperProvider config={config}>
      <RouterProvider router={routes} />
    </OidcWrapperProvider>
  );
};
