// noinspection JSUnusedGlobalSymbols

import './styles/index.css';
import { Outlet } from 'react-router';
import { SOApplication } from 'so-kit-ui';
import config from './app-config.jsx';
import locales from './i18n/index.js';
import { library } from './library.jsx';

export const App = () => {
  return (
    <SOApplication
      appNamespace='Company'
      appNamespaceAsI18nScope={false}
      debugTranslations={true}
      locales={locales}
      library={library}
      config={config}
    >
      <Outlet />
    </SOApplication>
  );
};
