import {
  DatePicker,
  Input,
  Section,
  SectionContainer,
  SectionTitle,
  Select,
} from 'so-kit-ui';

const legalForms = [
  {
    code: 'LLC',
    description: 'Limited Liability Company',
  },
  {
    code: 'CORP',
    description: 'Corporation',
  },
  {
    code: 'SOLO',
    description: 'Sole Proprietorship',
  },
  {
    code: 'PART',
    description: 'Partnership',
  },
  {
    code: 'LLP',
    description: 'Limited Liability Partnership',
  },
  {
    code: 'OT',
    description: 'Other',
  },
];

export const companyTypes = [
  {
    code: 'IT',
    description: 'Information Technology',
  },
  {
    code: 'ED',
    description: 'Education',
  },
  {
    code: 'RE',
    description: 'Research',
  },
  {
    code: 'FI',
    description: 'Financial',
  },
  {
    code: 'TR',
    description: 'Trade',
  },
  {
    code: 'OT',
    description: 'Other',
  },
];

const General = () => {
  return (
    <SectionContainer
      padded
      page
    >
      <Section columns={2}>
        <SectionTitle>title.general.info</SectionTitle>
        <Section.Elements>
          <Input id='companyName' />
          <Select
            id='legalForm'
            options={legalForms}
            vlCodeDescription
            valueOnly
          />
          <DatePicker id='establishedDate' />
          <Input
            id='capital'
            type='decimal'
            minValue={0}
            formatOptions={{
              maximumFractionDigits: 2,
            }}
          />
          <Input
            id='employees'
            type='number'
          />
          <Select
            id='type'
            options={companyTypes}
            vlCodeDescription
          />
        </Section.Elements>
      </Section>
      <Section>
        <SectionTitle>title.general.address</SectionTitle>
        <Section.Elements>
          <Input id='address.street' />
          <Input id='address.city' />
          <Input id='address.state' />
          <Input id='address.zip' />
        </Section.Elements>
      </Section>
      <Section>
        <SectionTitle>title.general.contact</SectionTitle>
        <Section.Elements>
          <Input id='website' />
          <Input id='phone' />
          <Input id='email' />
        </Section.Elements>
      </Section>
    </SectionContainer>
  );
};

export default General;
