import { Tag, VisualSubDocument } from 'so-kit-ui';
import ShareholdersForm from '../forms/ShareholdersForm.jsx';

const Line1 = ({ subDataTabsProps }) => {
  const fn = subDataTabsProps?.subData?.firstName ?? '';
  const ln = subDataTabsProps?.subData?.lastName ?? '';

  return (
    <div className='ps-2 max-w-full overflow-hidden'>
      <Tag color='base'>{`${fn} ${ln}`}</Tag>
    </div>
  );
};

const Line2 = ({ subDataTabsProps }) => {
  const shares = subDataTabsProps?.subData?.shares ?? '';
  const quote = subDataTabsProps?.subData?.percentage ?? '';

  return (
    <div className='max-w-full text-nowrap text-ellipsis overflow-hidden'>
      {`Shares: ${shares} - ${quote} %`}
    </div>
  );
};

const Shareholders = () => {
  return (
    <VisualSubDocument
      qpName='shareholder'
      path='shareholders'
      idAccessor='id'
      autoNumber={true}
      formComponent={<ShareholdersForm />}
      buttonNew={true}
      buttonNewId='btn.sh.new'
      buttonClone={true}
      buttonCloneId='btn.sh.clone'
      buttonDelete={true}
      buttonDeleteId='btn.sh.delete'
      tabLine1={Line1}
      tabLine2={Line2}
      tabEmptyPlaceHolder='empty.shareholders'
      formEmptyPlaceHolder='empty.shareholders'
      maxVerticalItems={9}
    />
  );
};

export default Shareholders;
