import tailwindcss from '@tailwindcss/vite';
import react from '@vitejs/plugin-react';
import { defineConfig } from 'vite';
import { VitePWA } from 'vite-plugin-pwa';

// https://vite.dev/config/
export default defineConfig({
  plugins: [
    react(),
    tailwindcss(),
    VitePWA({
      registerType: 'autoUpdate',
      injectRegister: 'auto',
      workbox: {
        globPatterns: ['**/*.{js,css,html,ico,jpg,png,svg}'],
      },
      devOptions: {
        enabled: true,
      },
      manifest: {
        id: 'com.strategyobject.com/company',
        name: 'StrategyObject Company',
        description: 'StrategyObject Company',
        short_name: 'SOCompany',
        start_url: '.',
        background_color: '#f5f5f4',
        theme_color: '#1de69f',
        display_override: ['standalone', 'browser', 'window-controls-overlay'],
        display: 'standalone',
        protocol_handlers: [
          {
            protocol: 'web+socompany',
            url: '/protocol?q=%s',
          },
        ],
        icons: [
          {
            src: 'pwa-16x16.png',
            sizes: '16x16',
            type: 'image/png',
          },
          {
            src: 'pwa-32x32.png',
            sizes: '32x32',
            type: 'image/png',
          },
          {
            src: 'pwa-48x48.png',
            sizes: '48x48',
            type: 'image/png',
          },
          {
            src: 'pwa-64x64.png',
            sizes: '64x64',
            type: 'image/png',
          },
          {
            src: 'pwa-128x128.png',
            sizes: '128x128',
            type: 'image/png',
          },
          {
            src: 'pwa-192x192.png',
            sizes: '192x192',
            type: 'image/png',
          },
          {
            src: 'pwa-256x256.png',
            sizes: '256x256',
            type: 'image/png',
          },
          {
            src: 'pwa-384x384.png',
            sizes: '384x384',
            type: 'image/png',
          },
          {
            src: 'pwa-512x512.png',
            sizes: '512x512',
            type: 'image/png',
          },
          {
            src: 'maskable-icon-16x16.png',
            sizes: '16x16',
            type: 'image/png',
            purpose: 'maskable',
          },
          {
            src: 'maskable-icon-32x32.png',
            sizes: '32x32',
            type: 'image/png',
            purpose: 'maskable',
          },
          {
            src: 'maskable-icon-48x48.png',
            sizes: '48x48',
            type: 'image/png',
            purpose: 'maskable',
          },
          {
            src: 'maskable-icon-64x64.png',
            sizes: '64x64',
            type: 'image/png',
            purpose: 'maskable',
          },
          {
            src: 'maskable-icon-128x128.png',
            sizes: '128x128',
            type: 'image/png',
            purpose: 'maskable',
          },
          {
            src: 'maskable-icon-192x192.png',
            sizes: '192x192',
            type: 'image/png',
            purpose: 'maskable',
          },
          {
            src: 'maskable-icon-256x256.png',
            sizes: '256x256',
            type: 'image/png',
            purpose: 'maskable',
          },
          {
            src: 'maskable-icon-384x384.png',
            sizes: '384x384',
            type: 'image/png',
            purpose: 'maskable',
          },
          {
            src: 'maskable-icon-512x512.png',
            sizes: '512x512',
            type: 'image/png',
            purpose: 'maskable',
          },
        ],
        screenshots: [
          {
            src: 'screenshot-laptop.png',
            sizes: '2732x2048',
            type: 'image/png',
            form_factor: 'wide',
            label: 'SO Trade Sphere',
          },
          {
            src: 'screenshot-mobile.png',
            sizes: '1170x2532',
            type: 'image/png',
            label: 'SO Trade Sphere (Mobile)',
          },
        ],
      },
    }),
  ],
  build: {
    cssCodeSplit: true,
    cssMinify: true,
    minify: true,
    terserOptions: {
      compress: true,
    },
    rollupOptions: {
      output: {
        manualChunks: (id) => {
          if (id?.includes('node_modules')) {
            const parts = id
              .substring(id.lastIndexOf('node_modules') + 12)
              .split('/');
            return parts[1];
          }

          return null;
        },
      },
    },
  },
});
