# SOKit UI

**Version**: `1.0.0-alpha.1`  
**Package Type**: ES module and CommonJS  
**Package Manager**: [pnpm](https://pnpm.io) (`pnpm@10.8.1`)

`so-kit-ui` is a modular and modern UI component library built for React 19+, featuring Storybook documentation, Tailwind CSS styling, and i18n support out of the box.

## Features

- Component-based design system
- Tailwind CSS and Tailwind Variants support
- Storybook for development and documentation
- i18next-based internationalization
- Tree-shakable builds (ESM and CJS)
- Built with Vite for rapid development and build

## Exports

| Path            | Description                     |
|-----------------|---------------------------------|
| `.`             | Main module (`.es.js` and `.cjs.js`) |
| `./styles`      | CSS output (`sokit-ui.css`)     |

## Scripts

### Development
- `pnpm dev` — Watch mode Vite build
- `pnpm dev:storybook` — Start Storybook in dev mode (port `6006`)

### Production
- `pnpm build` — Vite build for production
- `pnpm build:dev` — Vite build for production with source maps and non-minified output
- `pnpm build:storybook` — Build Storybook documentation

### Linting
- `pnpm lint` — Format code using Biome
- `pnpm lint:unsafe` — Lint and apply potentially unsafe fixes
- `pnpm lint:package` — Format `package.json` using Prettier

### Code Checking
- `pnpm check` — Run Biome checks

## Storybook

We use Storybook (`8.6.12`) with MSW addon support to document the UI components in isolation.

MSW workers are located in:
```
.storybook/public
```

## Dependencies

- React 19
- Tailwind CSS 4
- Lucide React Icons
- i18next + react-i18next
- React Aria Components
- And more...

> Peer dependencies such as `react`, `react-dom`, and `react-router` must be installed in the host application.

## Output Structure

All build outputs are located in the `/dist` folder.

- `dist/sokit-ui.es.js` — ES module build
- `dist/sokit-ui.cjs.js` — CommonJS build
- `dist/sokit-ui.css` — Compiled CSS

## Usage by SO Teams

Build and package the library using the following command:

```bash
pnpm build:dev

pnpm pack
```

Then, install the package in your project:

```bash
pnpm add ./path/to/sokit-ui-1.0.0-alpha.1.tgz
```

Note: There is a scaffolding application that can be used to initialize a new project with `so-kit-ui` and other dependencies. 